#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//smooth netMod01.fsh   by   Xecutor   
//https://www.shadertoy.com/view/mdBcWW
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float dtl(vec2 xy, vec2 p1, vec2 p2) {
    vec2 ab = p2-p1;
    if(abs(ab.x)>1e-5) {
        float a = ab.y/ab.x;
        float c=p1.y-p1.x*a;
        return abs(a*xy.x-xy.y+c)/sqrt(a*a+1.0);
    } else {
        return abs(xy.x-p1.x);
    }
}

float nline(vec2 xy, vec2 p1, vec2 p2) {
    float d= dtl(xy, p1, p2);
    d = pow(d,1.5)*10000.0;
    d = 1.0/(d+1.0);
    return d/3.0;
}

vec3 stclr(vec3 clr1, vec3 clr2, float v) {
    return vec3(smoothstep(clr1.x, clr2.x, v),smoothstep(clr1.y, clr2.y, v),smoothstep(clr1.z, clr2.z, v));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    //vec2 uv = (fragCoord * 2.0 - iResolution.xy) / iResolution.y;
    vec2 uv = fragCoord / iResolution.xy;//(fragCoord.x/iResolution.x, fragCoord.y/iResolution.y);
    const float n = 31.0;
    vec3 clr = vec3(0.0);
    vec3 plt[4];
    plt[0]=vec3(1.0,0.5,0.0);
    plt[1]=vec3(0.5,1.0,0.5);
    plt[2]=vec3(0.25,0.75,1.0);
    plt[3]=vec3(0.3,0.7,0.4);
    
    for(float j=0.0;j<n;++j) {
        float v = smoothstep(0.0,1.0,(mod(j+iTime,n))/(n-1.0));
        vec2 pts[4];
        pts[0] = vec2(0.0, v);
        pts[1] = vec2(v, 1.0);
        pts[2] = vec2(1.0, 1.0-v);
        pts[3] = vec2(1.0-v, 0.0);
        for(int i=0;i<4;++i) {
            clr += nline(uv, pts[i],pts[(i+1)%4]) * stclr(plt[i],plt[(i+1)%4],mod(j,n)/(n-1.0));
        }
    }
    
    vec2 c = vec2(0.5,0.5);
    float d = length(uv-c);
    float r = sin(atan(uv.x-c.x,uv.y-c.y)*30.0-iTime*6.0);
    
    float s = abs(r)*(0.4-clamp(d,0.0,0.4))*4.0;
    clr += vec3(r,r*r, (abs(sin(uv.x))+abs(cos(uv.y)))/2.0)*s;
    
    
    //cf *= 3.0;
    //vec3 col=vec3(clamp(cf-2.0,0.0,1.0),clamp(cf-1.0,0.0,1.0), clamp(cf,0.0,1.0));

    fragColor = vec4(clr,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

